/*
 * Decompiled with CFR 0.152.
 */
package com.zkryle.jeg.client.golem.models;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.zkryle.jeg.common.golem.MagmaticGolemEntity;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class MagmaticGolemEntityModel<T extends MagmaticGolemEntity>
extends EntityModel<T>
implements IHasArm {
    private final ModelRenderer wholebody;
    private final ModelRenderer neck;
    private final ModelRenderer arm1;
    private final ModelRenderer arm2;
    private final ModelRenderer leg1;
    private final ModelRenderer leg2;
    private final ModelRenderer stomach;
    private final ModelRenderer wholehead;
    private final ModelRenderer head;
    private final ModelRenderer cube_r1;
    private final ModelRenderer cube_r2;
    private final ModelRenderer cube_r3;

    public MagmaticGolemEntityModel() {
        this.field_78090_t = 32;
        this.field_78089_u = 32;
        this.wholebody = new ModelRenderer((Model)this);
        this.wholebody.func_78793_a(-0.5f, 18.0f, 0.0f);
        this.setRotationAngle(this.wholebody, -3.1416f, 0.0f, 3.1416f);
        this.neck = new ModelRenderer((Model)this);
        this.neck.func_78793_a(-0.1f, -2.0f, 0.0f);
        this.wholebody.func_78792_a(this.neck);
        this.neck.func_78784_a(0, 20).func_228303_a_(-1.6f, -1.0f, -1.6f, 3.0f, 1.0f, 3.0f, 0.0f, false);
        this.arm1 = new ModelRenderer((Model)this);
        this.arm1.func_78793_a(-3.5f, -1.0f, 0.0f);
        this.wholebody.func_78792_a(this.arm1);
        this.arm1.func_78784_a(16, 24).func_228303_a_(-2.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, false);
        this.arm2 = new ModelRenderer((Model)this);
        this.arm2.func_78793_a(3.5f, -1.0f, 0.0f);
        this.wholebody.func_78792_a(this.arm2);
        this.arm2.func_78784_a(24, 24).func_228303_a_(0.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, false);
        this.leg1 = new ModelRenderer((Model)this);
        this.leg1.func_78793_a(-1.5f, 4.0f, 0.0f);
        this.wholebody.func_78792_a(this.leg1);
        this.leg1.func_78784_a(8, 24).func_228303_a_(-1.0f, 0.0f, -1.1f, 2.0f, 2.0f, 2.0f, 0.0f, false);
        this.leg2 = new ModelRenderer((Model)this);
        this.leg2.func_78793_a(1.5f, 4.0f, 0.0f);
        this.wholebody.func_78792_a(this.leg2);
        this.leg2.func_78784_a(8, 28).func_228303_a_(-1.0f, 0.0f, -0.9f, 2.0f, 2.0f, 2.0f, 0.0f, false);
        this.stomach = new ModelRenderer((Model)this);
        this.stomach.func_78793_a(0.1f, 1.0f, 0.0f);
        this.wholebody.func_78792_a(this.stomach);
        this.stomach.func_78784_a(0, 8).func_228303_a_(-3.1f, 0.0f, -1.25f, 6.0f, 3.0f, 3.0f, 0.0f, false);
        this.stomach.func_78784_a(6, 0).func_228303_a_(-4.1f, -3.0f, -2.25f, 8.0f, 3.0f, 5.0f, 0.0f, false);
        this.wholehead = new ModelRenderer((Model)this);
        this.wholehead.func_78793_a(-0.1f, -2.4f, 0.0f);
        this.wholebody.func_78792_a(this.wholehead);
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(-0.1f, 0.0f, 0.0f);
        this.wholehead.func_78792_a(this.head);
        this.head.func_78784_a(12, 15).func_228303_a_(-2.3f, -4.0f, -2.6f, 5.0f, 4.0f, 5.0f, 0.0f, false);
        this.head.func_78784_a(0, 28).func_228303_a_(-0.3f, -2.0f, 2.0f, 1.0f, 2.0f, 2.0f, 0.0f, false);
        this.cube_r1 = new ModelRenderer((Model)this);
        this.cube_r1.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_78792_a(this.cube_r1);
        this.setRotationAngle(this.cube_r1, 0.0f, 0.0f, -0.1309f);
        this.cube_r1.func_78784_a(0, 16).func_228303_a_(-2.5f, -7.5f, 0.0f, 1.0f, 2.0f, 1.0f, 0.0f, false);
        this.cube_r2 = new ModelRenderer((Model)this);
        this.cube_r2.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_78792_a(this.cube_r2);
        this.setRotationAngle(this.cube_r2, 0.0f, 0.0f, 0.48f);
        this.cube_r2.func_78784_a(0, 16).func_228303_a_(-0.25f, -6.25f, 0.0f, 1.0f, 2.0f, 1.0f, 0.0f, false);
        this.cube_r3 = new ModelRenderer((Model)this);
        this.cube_r3.func_78793_a(0.0f, 0.0f, 0.0f);
        this.head.func_78792_a(this.cube_r3);
        this.setRotationAngle(this.cube_r3, 0.0f, 0.0f, -0.48f);
        this.cube_r3.func_78784_a(0, 16).func_228303_a_(-0.5f, -6.0f, 0.0f, 1.0f, 2.0f, 1.0f, 0.0f, false);
    }

    public void setupAnim(T entity, float pLimbSwing, float pLimbSwingAmount, float ageInTicks, float pNetHeadYaw, float pHeadPitch) {
        boolean flag = entity.func_184599_cB() > 4;
        boolean isOn = ((MagmaticGolemEntity)((Object)entity)).isOn();
        this.wholehead.field_78795_f = ((MagmaticGolemEntity)((Object)entity)).headInclination >= 0.0f ? pHeadPitch * ((float)(-Math.PI) / 180) : ((MagmaticGolemEntity)((Object)entity)).headInclination;
        this.wholehead.field_78796_g = pNetHeadYaw * ((float)Math.PI / 180);
        this.leg1.field_78795_f = isOn ? MathHelper.func_76134_b((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount : 0.0f;
        this.leg2.field_78795_f = isOn ? MathHelper.func_76134_b((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount : 0.0f;
        float f = 1.0f;
        if (flag) {
            f = (float)entity.func_213322_ci().func_189985_c();
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.arm2.field_78795_f = isOn ? MathHelper.func_76134_b((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 2.0f * pLimbSwingAmount * 0.5f / -f : 0.0f;
        this.arm1.field_78795_f = isOn ? MathHelper.func_76134_b((float)(pLimbSwing * 0.6662f)) * 2.0f * pLimbSwingAmount * 0.5f / -f : 0.0f;
        this.arm2.field_78808_h = 0.0f;
        this.arm1.field_78808_h = 0.0f;
        if (!entity.func_184614_ca().func_190926_b()) {
            this.arm2.field_78795_f = this.arm2.field_78795_f * 0.5f + 0.31415927f;
        }
        this.setupAttackAnimation(entity, ageInTicks);
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        matrixStack.func_227862_a_(1.5f, 1.5f, 1.5f);
        matrixStack.func_227861_a_((double)0.025f, -0.5, 0.0);
        this.wholebody.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    public void func_225599_a_(HandSide pSide, MatrixStack pMatrixStack) {
        pMatrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        pMatrixStack.func_227861_a_(-0.35, 2.3, 0.05);
        pMatrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        this.arm2.func_228307_a_(pMatrixStack);
        pMatrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(180.0f));
        pMatrixStack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(5.0f));
    }

    protected ModelRenderer getArm(HandSide pSide) {
        return pSide == HandSide.LEFT ? this.arm2 : this.arm1;
    }

    protected void setupAttackAnimation(T p_230486_1_, float p_230486_2_) {
        if (!(this.field_217112_c <= 0.0f)) {
            HandSide handside = HandSide.RIGHT;
            ModelRenderer modelrenderer = this.arm2;
            float f = this.field_217112_c;
            f = 1.0f - this.field_217112_c;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = MathHelper.func_76126_a((float)(f * (float)Math.PI));
            float f2 = MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -(this.head.field_78795_f - 0.7f) * 0.75f;
            modelrenderer.field_78795_f = (float)((double)modelrenderer.field_78795_f + ((double)f1 * 1.2 + (double)f2));
            modelrenderer.field_78808_h += MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * 0.4f;
        }
    }

    public void func_217111_a(EntityModel<T> p_217111_1_) {
        p_217111_1_.field_217112_c = this.field_217112_c;
        p_217111_1_.field_217113_d = this.field_217113_d;
        p_217111_1_.field_217114_e = this.field_217114_e;
        super.func_217111_a(p_217111_1_);
    }
}

